//Source file: H:\src\Alkindi\Services\InternalData\UserEvalInfo.java

/* Copyright (C) 2000-2001 Alkindi, Inc. */

package Alkindi.Services.InternalData;

import Alkindi.Data.SystemUser;

/**
 * Represents information about a user's evaluations and the number of Core and Selectable products. Returned by getUserUsed to calculate weights in RatingManager.getProductsToRate.
 */
public class UserEvalInfo 
{
	
	/**
	 * The number of <b>Core</b> products shown to the user.
	 */
	public int coreShown = 0;
	
	/**
	 * The ratio of the number of products the user rated, to the number of products shown to the user.
	 */
	public float epsilonUser;
	
	/**
	 * The ratio of the number of products rated to the number of products shown. This is with regard to all users.
	 */
	public float epsilonEveryone;
	
	/**
	 * The number of <b>Selectable</b> products shown to the user.
	 */
	public int selectableShown = 0;
	
	/**
	 * The total number of <b>Core</b> products.
	 */
	public int totalCore = 0;
	
	/**
	 * The total number of <b>Selectable</b> products.
	 */
	public int totalSelectable = 0;
	
	/**
	 * The SystemUser for whom this evaulation information is assembled.
	 */
	public SystemUser user = null;
	
	/**
	 * Constructor to populate all members.
	 * @roseuid 3AF6F96D00DA
	 */
	public UserEvalInfo(final SystemUser userIn, final int coreShownIn, final int selectableShownIn, final int totalCoreIn, final int totalSelectableIn, final float epsilonUserIn, final float epsilonEveryoneIn) 
	{
	}
}
